package ga.core.individual;

import org.apache.commons.math.stat.clustering.Clusterable;

/**
 * Interface for individuals that is clusterable.
 * 
 * @param <T>
 *          The generic type of individuals.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public interface IClusterableIndividual<T extends IClusterableIndividual<T>>
    extends IIndividual<T>, Clusterable<T> {

  /**
   * Calculates the distance from this individual to the second individual,
   * normalized to [0;1].
   * 
   * @param ind2
   *          The second individual
   * @return Normalized distance of this individual from the second individual.
   * @since 18.02.2012
   * @author Stephan Dreyer
   */
  @Override
  public double distanceFrom(final T ind2);

}
